/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.codexadrian.tempad.data.LocationData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class TempadComponent {
    private final Map<UUID, LocationData> locations = new HashMap<UUID, LocationData>();

    public void toStack(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41784_();
        ListTag locationData = new ListTag();
        for (LocationData data : this.locations.values()) {
            locationData.add((Object)data.toTag());
        }
        compoundTag.m_128365_("tempad_locations", (Tag)locationData);
        stack.m_41751_(compoundTag);
    }

    public static TempadComponent fromStack(ItemStack stack) {
        TempadComponent component = new TempadComponent();
        CompoundTag compoundTag = stack.m_41784_();
        ListTag locationData = compoundTag.m_128437_("tempad_locations", 10);
        for (Tag dataTag : locationData) {
            component.addLocation(LocationData.fromTag((CompoundTag)dataTag));
        }
        return component;
    }

    public static void addStackLocation(ItemStack stack, LocationData data) {
        TempadComponent component = TempadComponent.fromStack(stack);
        component.addLocation(data);
        component.toStack(stack);
    }

    public static void deleteStackLocation(ItemStack stack, UUID id) {
        TempadComponent component = TempadComponent.fromStack(stack);
        component.removeLocation(id);
        component.toStack(stack);
    }

    public void addLocation(LocationData data) {
        this.locations.put(data.getId(), data);
    }

    public Collection<LocationData> getLocations() {
        return this.locations.values();
    }

    public void removeLocation(UUID id) {
        System.out.println("Removing Location with ID: " + id.toString());
        this.locations.remove(id);
    }
}

